#!/bin/sh

[ -n "$1" ] || (echo "USAGE: $0 FILE"; exit)

dir=$(mktemp -d)/upload
cpu="arduino:avr:mega:cpu=atmega2560"
mkdir -p ${dir}

echo "#define DATA_AMOUNT $(wc -c $1 | awk '{print $1}')" > ${dir}/data.h
echo 'const PROGMEM uint8_t data[DATA_AMOUNT] = {' >> ${dir}/data.h
cat $1 | xxd -i >> ${dir}/data.h
echo '};' >> ${dir}/data.h

echo '#include "data.h"
#define WE 53
#define ADDRESS 22
#define DATA 38

void
setup()
{
	unsigned int i, j;
	pinMode(LED_BUILTIN, OUTPUT);
	digitalWrite(LED_BUILTIN, LOW);

	for (i = 0; i < 15; i++)
		pinMode(ADDRESS+i, OUTPUT);

	for (i = 0; i < 8; i++)
		pinMode(DATA+i, OUTPUT);
	
	pinMode(WE, OUTPUT);
	digitalWrite(WE, HIGH);

	for (i = 0; i < DATA_AMOUNT; i++) {
		for (j = 0; j < 15; j++)
			digitalWrite(ADDRESS+j, (i>>j) & 1);
		for (j = 0; j < 8; j++)
			digitalWrite(DATA+j, (pgm_read_byte_near(data+i)>>j) & 1);
		digitalWrite(WE, LOW);
		delay(1);
		digitalWrite(WE, HIGH);
		delay(10);
	}
	digitalWrite(LED_BUILTIN, HIGH);
}

void loop(){}' > ${dir}/upload.ino

sudo chmod a+rw /dev/ttyUSB0

arduino-cli compile --fqbn "${cpu}" ${dir}
arduino-cli upload -p /dev/ttyUSB0 --fqbn "${cpu}" ${dir}

rm -rf ${dir}
